/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Vector;
import javax.swing.JOptionPane;
import logger.Logger;
import server.Client;
import server.ClientDisconnectHandler;
import server.SQLResult;
import server.ServerWindow;
import server.UserDBMS;
import shared.UserNetworkData;
import signal.BroadcastLoginSignal;
import signal.ChangeNicknameSignal;
import signal.ChangePersonalMessageSignal;
import signal.ChangeStatusSignal;
import signal.MessageSignal;

public class Server
extends Thread {
    private ServerSocket m_connection;
    private Vector<Client> m_clients = new Vector();
    private ClientDisconnectHandler m_disconnectHandler;
    private static int m_clientCounter = 0;
    private UserDBMS m_dbms = new UserDBMS();
    private Logger m_logger = new Logger();

    public Server() {
        this.m_disconnectHandler = new ClientDisconnectHandler();
    }

    public void initialize(int port, ServerWindow serverWindow) {
        if (port < 0 || port > 65355) {
            port = 25500;
        }
        this.m_logger.initialize(serverWindow);
        try {
            this.m_connection = new ServerSocket(port);
        }
        catch (Exception e) {
            this.m_logger.addError("Unable to initialize server on port " + port + ": " + e.getMessage());
            JOptionPane.showMessageDialog(null, "Unable to initialize server on port " + port + ": " + e.getMessage(), "Error Initializing Server", 0);
            System.exit(1);
        }
        this.m_logger.addInfo("Successfully started server on port: " + port);
        this.m_dbms.initialize(this.m_logger);
        this.m_dbms.connect();
        this.m_disconnectHandler.initialize(this.m_clients, this.m_logger);
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    @Override
    public void run() {
        while (true) {
            Client newClient = null;
            ++m_clientCounter;
            try {
                newClient = new Client(this.m_connection.accept(), m_clientCounter);
            }
            catch (IOException e) {
                this.m_logger.addError("Unable to connect to client #" + m_clientCounter);
            }
            if (newClient != null) {
                newClient.initialize(this, this.m_logger);
                this.m_clients.add(newClient);
                this.m_logger.addInfo("Established connection to client #" + newClient.getClientNumber() + " at " + newClient.getIPAddressString());
            }
            try {
                Server.sleep(75L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public int numberOfClients() {
        return this.m_clients.size();
    }

    public Client getClient(int index) {
        if (index < 0 || index >= this.m_clients.size()) {
            return null;
        }
        return this.m_clients.elementAt(index);
    }

    public UserDBMS getDBMS() {
        return this.m_dbms;
    }

    public void databaseConnect() {
        this.m_dbms.connect();
    }

    public void databaseDisconnect() {
        this.m_dbms.disconnect();
    }

    public boolean databaseConnnected() {
        return this.m_dbms.isConnected();
    }

    public void createTables() {
        this.m_dbms.createTables();
    }

    public void dropTables() {
        this.m_dbms.dropTables();
    }

    public void resetTables() {
        this.m_dbms.resetTables();
    }

    public boolean createUser(Client client, String userName, String password) {
        boolean userCreated = this.m_dbms.createUser(userName, password);
        if (userCreated && client.getUserName() == null) {
            client.setUserName(userName);
            client.setPassword(password);
        }
        return userCreated;
    }

    public boolean deleteUser(String userName) {
        boolean userDeleted = this.m_dbms.deleteUser(userName);
        if (userDeleted) {
            int i = 0;
            while (i < this.m_clients.size()) {
                String clientUserName = this.m_clients.elementAt(i).getUserName();
                if (clientUserName != null && clientUserName.equalsIgnoreCase(userName)) {
                    this.m_clients.elementAt(i).disconnect();
                    this.m_logger.addInfo("Client #" + this.m_clients.elementAt(i).getClientNumber() + " (" + clientUserName + ") disconnecting: account deleted");
                    break;
                }
                ++i;
            }
        }
        return userDeleted;
    }

    public boolean userLogin(Client client, String userName, String password) {
        boolean alreadyLoggedIn = false;
        int i = 0;
        while (i < this.m_clients.size()) {
            if (userName.equalsIgnoreCase(this.m_clients.elementAt(i).getUserName())) {
                alreadyLoggedIn = true;
            }
            ++i;
        }
        boolean authenticated = false;
        if (!alreadyLoggedIn && (authenticated = this.m_dbms.userLogin(userName, password))) {
            client.setUserName(userName);
            client.setPassword(password);
            client.setNickName(this.m_dbms.getUserNickName(userName));
            client.setPersonalMessage(this.m_dbms.getUserPersonalMessage(userName));
        }
        return authenticated;
    }

    public void broadcastUserLogin(BroadcastLoginSignal s, Vector<UserNetworkData> contacts) {
        if (s == null || contacts == null) {
            return;
        }
        this.m_dbms.updateUserStatus(s.getData().getUserName(), s.getData().getStatus());
        int i = 0;
        while (i < this.m_clients.size()) {
            String clientUserName = this.m_clients.elementAt(i).getUserName();
            int j = 0;
            while (j < contacts.size()) {
                if (clientUserName != null && clientUserName.equalsIgnoreCase(contacts.elementAt(j).getUserName())) {
                    s.getData().setBlocked(this.userHasContactBlocked(contacts.elementAt(j).getUserName(), s.getData().getUserName()));
                    this.m_clients.elementAt(i).sendSignal(s);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean changeUserPassword(Client client, String userName, String oldPassword, String newPassword) {
        if (client.getUserName() != null && client.getUserName().equalsIgnoreCase(userName) && this.m_dbms.changeUserPassword(userName, oldPassword, newPassword)) {
            client.setPassword(newPassword);
            return true;
        }
        return false;
    }

    public UserNetworkData addUserContact(Client client, String contactUserName) {
        if (client == null || contactUserName == null) {
            return null;
        }
        if (client.getUserName() != null) {
            UserNetworkData data = this.m_dbms.addUserContact(client.getUserName(), contactUserName);
            if (data != null) {
                int i = 0;
                while (i < this.m_clients.size()) {
                    Client c = this.m_clients.elementAt(i);
                    if (c.getUserName() != null && c.getUserName().equalsIgnoreCase(data.getUserName())) {
                        data.setStatus((byte)1);
                        data.setIPAddress(c.getIPAddress());
                        data.setPort(c.getPort());
                    }
                    ++i;
                }
            }
            return data;
        }
        return null;
    }

    public boolean deleteUserContact(Client client, String contactUserName) {
        if (client == null || contactUserName == null) {
            return false;
        }
        if (client.getUserName() != null) {
            return this.m_dbms.deleteUserContact(client.getUserName(), contactUserName);
        }
        return false;
    }

    public boolean userHasContactBlocked(String userName, String contactUserName) {
        if (userName == null || contactUserName == null) {
            return false;
        }
        return this.m_dbms.userHasContactBlocked(userName, contactUserName);
    }

    public int blockUserContact(Client client, String contactUserName, boolean blocked) {
        if (client == null || contactUserName == null) {
            return 2;
        }
        if (client.getUserName() != null) {
            return this.m_dbms.setBlockUserContact(client.getUserName(), contactUserName, blocked);
        }
        return 2;
    }

    public void forwardMessage(MessageSignal s) {
        if (s == null) {
            return;
        }
        int i = 0;
        while (i < this.m_clients.size()) {
            if (this.m_clients.elementAt(i).getUserName().equalsIgnoreCase(s.getContactUserName())) {
                this.m_clients.elementAt(i).sendSignal(new MessageSignal(s.getMessage(), s.getMessageID(), s.getContactUserName(), s.getUserName()));
                break;
            }
            ++i;
        }
    }

    public boolean updateUserNickName(Client client, String nickName) {
        if (client == null) {
            return false;
        }
        if (!this.m_dbms.updateUserNickName(client.getUserName(), nickName)) {
            return false;
        }
        client.setNickName(nickName);
        Vector<UserNetworkData> contacts = this.getUserContacts(client.getUserName());
        if (contacts == null) {
            return true;
        }
        int i = 0;
        while (i < this.m_clients.size()) {
            int j = 0;
            while (j < contacts.size()) {
                if (this.m_clients.elementAt(i).getUserName() != null && this.m_clients.elementAt(i).getUserName().equalsIgnoreCase(contacts.elementAt(j).getUserName())) {
                    this.m_clients.elementAt(i).sendSignal(new ChangeNicknameSignal(client.getUserName(), nickName));
                    contacts.remove(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean updateUserPersonalMessage(Client client, String personalMessage) {
        if (client == null) {
            return false;
        }
        if (!this.m_dbms.updateUserPersonalMessage(client.getUserName(), personalMessage)) {
            return false;
        }
        client.setPersonalMessage(personalMessage);
        Vector<UserNetworkData> contacts = this.getUserContacts(client.getUserName());
        if (contacts == null) {
            return true;
        }
        int i = 0;
        while (i < this.m_clients.size()) {
            int j = 0;
            while (j < contacts.size()) {
                if (this.m_clients.elementAt(i).getUserName() != null && this.m_clients.elementAt(i).getUserName().equalsIgnoreCase(contacts.elementAt(j).getUserName())) {
                    this.m_clients.elementAt(i).sendSignal(new ChangePersonalMessageSignal(client.getUserName(), personalMessage));
                    contacts.remove(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean updateUserStatus(Client client, byte status) {
        if (client == null) {
            return false;
        }
        if (!this.m_dbms.updateUserStatus(client.getUserName(), status)) {
            return false;
        }
        client.setStatus(status);
        Vector<UserNetworkData> contacts = this.getUserContacts(client.getUserName());
        if (contacts == null) {
            return true;
        }
        int i = 0;
        while (i < this.m_clients.size()) {
            int j = 0;
            while (j < contacts.size()) {
                if (this.m_clients.elementAt(i).getUserName() != null && this.m_clients.elementAt(i).getUserName().equalsIgnoreCase(contacts.elementAt(j).getUserName())) {
                    this.m_clients.elementAt(i).sendSignal(new ChangeStatusSignal(client.getUserName(), status));
                    contacts.remove(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public Vector<UserNetworkData> getUserContacts(String userName) {
        return this.m_dbms.getUserContacts(userName, this.m_clients);
    }

    public int executeUpdate(String query) {
        return this.m_dbms.executeUpdate(query);
    }

    public SQLResult executeQuery(String query) {
        return this.m_dbms.executeQuery(query);
    }

    public Object[] getLastSystemLogEntryAsArray() {
        return this.m_logger.getLastSystemLogEntryAsArray();
    }

    public Object[] getLastCommandLogEntryAsArray() {
        return this.m_logger.getLastCommandLogEntryAsArray();
    }
}

