/*
 * Decompiled with CFR 0.152.
 */
package signal;

import java.net.InetAddress;
import shared.ByteStream;
import shared.FontStyle;
import shared.UserData;
import shared.UserNetworkData;
import signal.Signal;

public class BroadcastLoginSignal
extends Signal {
    private UserNetworkData m_data;
    public static final int LENGTH = 932;

    private BroadcastLoginSignal() {
        super(6);
    }

    public BroadcastLoginSignal(String userName, String nickName, String personalMessage, byte status, FontStyle font) {
        this(userName, nickName, personalMessage, status, font, false, null, 0);
    }

    public BroadcastLoginSignal(UserNetworkData data) {
        this(data.getUserName(), data.getNickName(), data.getPersonalMessage(), data.getStatus(), data.getFont(), data.isBlocked(), data.getIPAddress(), data.getPort());
    }

    public BroadcastLoginSignal(UserData data) {
        this(data.getUserName(), data.getNickName(), data.getPersonalMessage(), data.getStatus(), data.getFont(), false, null, 0);
    }

    public BroadcastLoginSignal(String userName, String nickName, String personalMessage, byte status, FontStyle font, boolean blocked, InetAddress ipAddress, int port) {
        super(6);
        this.m_data = new UserNetworkData(userName, nickName, personalMessage, status, font, blocked, ipAddress, port);
    }

    public UserNetworkData getData() {
        return this.m_data;
    }

    @Override
    public long checksum() {
        return this.m_data.checksum();
    }

    public static BroadcastLoginSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        BroadcastLoginSignal s2 = new BroadcastLoginSignal();
        s2.m_data = UserNetworkData.readFrom(byteStream);
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        this.m_data.writeTo(byteStream);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return BroadcastLoginSignal.readFrom(byteStream);
    }
}

