/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import shared.UserNetworkData;
import signal.Signal;

public class ContactAddedSignal
extends Signal {
    private UserNetworkData m_data;
    private boolean m_added;
    public static final int LENGTH = 933;

    private ContactAddedSignal() {
        super(13);
    }

    public ContactAddedSignal(UserNetworkData data, boolean added) {
        super(13);
        this.m_data = data;
        this.m_added = added;
    }

    public UserNetworkData getData() {
        return this.m_data;
    }

    public boolean getAdded() {
        return this.m_added;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += this.m_data.checksum();
        return checksum += ByteStream.getChecksum(this.m_added);
    }

    public static ContactAddedSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        ContactAddedSignal s2 = new ContactAddedSignal();
        s2.m_data = UserNetworkData.readFrom(byteStream);
        s2.m_added = byteStream.nextBoolean();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        this.m_data.writeTo(byteStream);
        byteStream.addBoolean(this.m_added);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return ContactAddedSignal.readFrom(byteStream);
    }
}

