/*
 * Decompiled with CFR 0.152.
 */
package signal;

import java.io.DataInputStream;
import shared.ByteStream;
import signal.Signal;

public class MessageSignal
extends Signal {
    private long m_messageID;
    private String m_userName;
    private String m_contactUserName;
    private int m_messageLength = -1;
    private String m_message;
    public static final int LENGTH = 148;

    private MessageSignal() {
        super(7);
    }

    public MessageSignal(String message, long messageID, String userName, String contactUserName) {
        super(7);
        this.m_messageID = messageID;
        this.m_userName = userName;
        this.m_contactUserName = contactUserName;
        this.m_message = message;
        this.m_messageLength = message.length();
    }

    public long getMessageID() {
        return this.m_messageID;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getContactUserName() {
        return this.m_contactUserName;
    }

    public int getMessageLength() {
        return this.m_messageLength;
    }

    public String getMessage() {
        return this.m_message;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_messageID);
        checksum += ByteStream.getChecksum(this.m_userName, 32);
        checksum += ByteStream.getChecksum(this.m_contactUserName, 32);
        checksum += ByteStream.getChecksum(this.m_message.length());
        return checksum += ByteStream.getChecksum(this.m_message);
    }

    public static MessageSignal readFrom(ByteStream byteStream, DataInputStream in) {
        if (byteStream == null || in == null) {
            return null;
        }
        MessageSignal s2 = new MessageSignal();
        s2.m_messageID = byteStream.nextLong();
        s2.m_userName = byteStream.nextString(32);
        s2.m_contactUserName = byteStream.nextString(32);
        s2.m_messageLength = byteStream.nextInteger();
        long checksum = byteStream.nextLong();
        s2.m_message = s2.m_messageLength > 0 ? ByteStream.readFrom(in, s2.m_messageLength * 16).nextString(s2.m_messageLength) : "";
        if (s2.m_message == null) {
            s2.m_message = "";
        }
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addLong(this.m_messageID);
        byteStream.addStringFixedLength(this.m_userName, 32);
        byteStream.addStringFixedLength(this.m_contactUserName, 32);
        byteStream.addInteger(this.m_message.length());
        byteStream.addLong(this.checksum());
        byteStream.addString(this.m_message);
    }
}

