/*
 * Decompiled with CFR 0.152.
 */
package block;

public class BlockState {
    public static final byte Unknown = 0;
    public static final byte Located = 1;
    public static final byte Missing = 2;
    public static final byte Moving = 3;
    public static final byte Delivered = 4;
    public static final String[] blockStates = new String[]{"Unknown", "Located", "Missing", "Moving", "Delivered"};

    public static boolean isValid(byte state) {
        return state >= 0 && state < blockStates.length;
    }

    public static byte parseFrom(String data) {
        if (data == null) {
            return -1;
        }
        String temp = data.trim();
        byte i = 0;
        while (i < blockStates.length) {
            if (temp.equalsIgnoreCase(blockStates[i])) {
                return i;
            }
            i = (byte)(i + 1);
        }
        return -1;
    }

    public static String toString(byte blockState) {
        return !BlockState.isValid(blockState) ? "Invalid" : blockStates[blockState];
    }
}

