/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import server.ClientInputSignalQueue;
import server.ClientOutputSignalQueue;
import server.ClientThread;
import server.Server;
import server.SystemManager;
import signal.ReceiveTrackerNumberSignal;
import signal.Signal;

public class Client {
    private int m_clientNumber;
    private InetAddress m_ipAddress;
    private byte m_trackerNumber = (byte)-1;
    private Socket m_connection;
    private boolean m_connected = false;
    private DataInputStream m_in;
    private DataOutputStream m_out;
    private ClientInputSignalQueue m_inSignalQueue;
    private ClientOutputSignalQueue m_outSignalQueue;
    private ClientThread m_clientThread = null;
    private int m_timeElapsed = 0;
    private boolean m_awaitingResponse = false;
    private Server m_server;
    public static int currentPort = 25502;

    public Client(Socket connection, int clientNumber) {
        this.m_clientNumber = clientNumber;
        this.m_connection = connection;
        this.m_inSignalQueue = new ClientInputSignalQueue();
        this.m_outSignalQueue = new ClientOutputSignalQueue();
        this.m_ipAddress = connection.getInetAddress();
    }

    public void initialize(Server server) {
        this.m_connected = true;
        try {
            this.m_server = server;
            this.m_out = new DataOutputStream(this.m_connection.getOutputStream());
            this.m_in = new DataInputStream(this.m_connection.getInputStream());
            this.m_inSignalQueue.initialize(this.m_server, this, this.m_in, this.m_outSignalQueue);
            this.m_outSignalQueue.initialize(this, this.m_out);
            if (this.m_clientThread == null || this.m_clientThread.isTerminated()) {
                this.m_clientThread = new ClientThread();
                this.m_clientThread.initialize(this);
            }
        }
        catch (IOException e) {
            this.m_connected = false;
            SystemManager.console.writeLine("Unable to initalize connection to client #" + this.m_clientNumber);
        }
    }

    public boolean isIdentified() {
        return this.m_trackerNumber >= 1;
    }

    public byte getTrackerNumber() {
        return this.m_trackerNumber;
    }

    public void setTrackerNumber(byte trackerNumber) {
        this.m_trackerNumber = trackerNumber;
        this.sendSignal(new ReceiveTrackerNumberSignal(this.m_trackerNumber));
        this.m_server.requestTrackerImages(this.m_trackerNumber);
    }

    public Socket getConnection() {
        return this.m_connection;
    }

    public InetAddress getIPAddress() {
        return this.m_ipAddress;
    }

    public String getIPAddressString() {
        return this.m_ipAddress == null ? "" : this.m_ipAddress.getHostAddress();
    }

    public boolean isConnected() {
        return this.m_connected && !this.timeout();
    }

    public boolean ping() {
        if (!this.m_awaitingResponse && (long)this.m_timeElapsed >= 5000L) {
            this.m_timeElapsed = 0;
            this.m_awaitingResponse = true;
            this.m_outSignalQueue.addSignal(new Signal(0));
            return true;
        }
        return false;
    }

    public void pong() {
        this.m_timeElapsed = 0;
        this.m_awaitingResponse = false;
    }

    public boolean awaitingResponse() {
        return this.m_awaitingResponse;
    }

    public int timeElapsed() {
        return this.m_timeElapsed;
    }

    public void addTime(long time) {
        if (time <= 0L) {
            return;
        }
        this.m_timeElapsed = (int)((long)this.m_timeElapsed + time);
    }

    public boolean timeout() {
        return this.m_awaitingResponse && (long)this.m_timeElapsed >= 32000L;
    }

    public void disconnect() {
        this.m_connected = false;
        try {
            if (this.m_out != null) {
                this.m_out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.m_in != null) {
                this.m_in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_out = null;
        this.m_in = null;
        this.m_connection = null;
    }

    public DataInputStream getInputStream() {
        return this.m_in;
    }

    public DataOutputStream getOutputStream() {
        return this.m_out;
    }

    public int getClientNumber() {
        return this.m_clientNumber;
    }

    public String getName() {
        return this.isIdentified() ? "Tracker #" + this.m_trackerNumber : "Client #" + this.m_clientNumber;
    }

    public void sendSignal(Signal s) {
        if (s == null) {
            return;
        }
        this.m_outSignalQueue.addSignal(s);
    }

    public void readSignal() {
        if (this.m_inSignalQueue == null) {
            return;
        }
        this.m_inSignalQueue.readSignal();
    }
}

