/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.util.Vector;
import server.Client;
import server.SystemManager;

public class ClientDisconnectHandler
extends Thread {
    private Vector<Client> m_clients;

    public void initialize(Vector<Client> clients) {
        this.m_clients = clients;
        if (this.m_clients == null) {
            return;
        }
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    public boolean isTerminated() {
        return this.getState() == Thread.State.TERMINATED;
    }

    @Override
    public void run() {
        while (true) {
            int i = 0;
            while (i < this.m_clients.size()) {
                Client c = this.m_clients.elementAt(i);
                c.addTime(100L);
                c.ping();
                if (!c.isConnected()) {
                    c.disconnect();
                    this.m_clients.remove(i);
                    --i;
                    if (c.timeout()) {
                        SystemManager.console.writeLine(String.valueOf(c.isIdentified() ? "Tracker #" + c.getTrackerNumber() : "Client #" + c.getClientNumber()) + " timed out");
                    }
                }
                ++i;
            }
            try {
                ClientDisconnectHandler.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

