/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Vector;
import javax.swing.JOptionPane;
import server.Client;
import server.ClientDisconnectHandler;
import server.SystemManager;
import server.TrackerIdentifier;
import signal.RequestTrackerImageSignal;
import signal.Signal;

public class Server
extends Thread {
    private ServerSocket m_connection;
    private Vector<Client> m_clients = new Vector();
    private ClientDisconnectHandler m_disconnectHandler = new ClientDisconnectHandler();
    private TrackerIdentifier m_trackerIdentifier = new TrackerIdentifier();
    private static int m_clientCounter = 0;
    public static final int DEFAULT_PORT = 25500;
    public static final long QUEUE_INTERVAL = 50L;
    public static final long CONNECTION_LISTEN_INTERVAL = 75L;
    public static final long TIMEOUT_INTERVAL = 100L;
    public static final long PING_INTERVAL = 5000L;
    public static final long CONNECTION_TIMEOUT = 32000L;

    public void initialize() {
        this.initialize(-1);
    }

    public void initialize(int port) {
        if (port < 0 || port > 65355) {
            port = SystemManager.settings.getPort();
        }
        try {
            this.m_connection = new ServerSocket(port);
        }
        catch (Exception e) {
            SystemManager.console.writeLine("Unable to initialize server on port " + port + ": " + e.getMessage());
            JOptionPane.showMessageDialog(null, "Unable to initialize server on port " + port + ": " + e.getMessage(), "Error Initializing Server", 0);
            System.exit(1);
        }
        SystemManager.console.writeLine("Successfully started server on port: " + port);
        this.m_disconnectHandler.initialize(this.m_clients);
        this.m_trackerIdentifier.initialize(this);
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    @Override
    public void run() {
        while (true) {
            Client newClient = null;
            ++m_clientCounter;
            try {
                newClient = new Client(this.m_connection.accept(), m_clientCounter);
            }
            catch (IOException e) {
                SystemManager.console.writeLine("Unable to connect to client #" + m_clientCounter);
            }
            if (newClient != null) {
                newClient.initialize(this);
                this.m_clients.add(newClient);
                this.m_trackerIdentifier.add(newClient);
                SystemManager.console.writeLine("Established connection to client #" + newClient.getClientNumber() + " at " + newClient.getIPAddressString());
            }
            try {
                Server.sleep(75L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public int numberOfClients() {
        return this.m_clients.size();
    }

    public Client getClient(int index) {
        if (index < 0 || index >= this.m_clients.size()) {
            return null;
        }
        return this.m_clients.elementAt(index);
    }

    public void forwardSignal(int clientNumber, Signal signal) {
        if (signal == null) {
            return;
        }
        int i = 0;
        while (i < this.m_clients.size()) {
            if (clientNumber != this.m_clients.elementAt(i).getClientNumber() && this.m_clients.elementAt(i).isIdentified()) {
                this.m_clients.elementAt(i).sendSignal(signal);
            }
            ++i;
        }
    }

    public void forwardToTracker(byte sourceTrackerNumber, byte destinationTrackerNumber, Signal signal) {
        if (signal == null || sourceTrackerNumber <= 0 || destinationTrackerNumber <= 0) {
            return;
        }
        int i = 0;
        while (i < this.m_clients.size()) {
            if (sourceTrackerNumber != this.m_clients.elementAt(i).getTrackerNumber() && this.m_clients.elementAt(i).getTrackerNumber() == destinationTrackerNumber) {
                this.m_clients.elementAt(i).sendSignal(signal);
            }
            ++i;
        }
    }

    public void requestTrackerImages(byte sourceTrackerNumber) {
        if (sourceTrackerNumber <= 0) {
            return;
        }
        RequestTrackerImageSignal s = new RequestTrackerImageSignal(sourceTrackerNumber);
        int i = 0;
        while (i < this.m_clients.size()) {
            if (sourceTrackerNumber != this.m_clients.elementAt(i).getTrackerNumber()) {
                this.m_clients.elementAt(i).sendSignal(s);
            }
            ++i;
        }
    }
}

