/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.net.InetAddress;
import java.util.Vector;
import javax.swing.JOptionPane;
import server.Client;
import server.Server;
import server.SystemManager;
import settings.SettingsManager;

public class TrackerIdentifier
extends Thread {
    private Vector<Client> m_trackers = new Vector();
    private Server m_server;

    public void initialize(Server server) {
        this.m_server = server;
        if (this.m_server == null) {
            return;
        }
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    public boolean isTerminated() {
        return this.getState() == Thread.State.TERMINATED;
    }

    public void add(Client c) {
        if (c == null) {
            return;
        }
        this.m_trackers.add(c);
    }

    @Override
    public void run() {
        block6: while (true) {
            if (this.m_trackers.size() == 0) {
                try {
                    TrackerIdentifier.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            int numberOfIdentifiedTrackers = 0;
            int numberOfUnidentifiedTrackers = 0;
            boolean[] identifiedTrackers = new boolean[SettingsManager.defaultTrackerIPAddress.length];
            int i = 0;
            while (i < this.m_server.numberOfClients()) {
                Client c = this.m_server.getClient(i);
                if (c.getTrackerNumber() >= 1 && c.getTrackerNumber() <= identifiedTrackers.length && !identifiedTrackers[c.getTrackerNumber() - 1]) {
                    identifiedTrackers[c.getTrackerNumber() - 1] = true;
                }
                ++i;
            }
            boolean allTrackersIdentified = true;
            int i2 = 0;
            while (i2 < identifiedTrackers.length) {
                if (!identifiedTrackers[i2]) {
                    allTrackersIdentified = false;
                } else {
                    ++numberOfIdentifiedTrackers;
                }
                ++i2;
            }
            numberOfUnidentifiedTrackers = SettingsManager.defaultTrackerIPAddress.length - numberOfIdentifiedTrackers;
            if (allTrackersIdentified) {
                JOptionPane.showMessageDialog(null, "Maximum number of trackers already connected!", "Too Many Trackers", 0);
                i2 = 0;
                while (true) {
                    if (i2 >= this.m_trackers.size()) continue block6;
                    this.m_trackers.elementAt(i2).disconnect();
                    this.m_trackers.remove(i2);
                    --i2;
                    ++i2;
                }
            }
            i2 = 0;
            while (i2 < this.m_trackers.size()) {
                Client c = this.m_trackers.elementAt(i2);
                boolean trackerIdentified = false;
                Object[] trackerChoices = new String[numberOfUnidentifiedTrackers];
                int k = 0;
                int j = 0;
                while (j < identifiedTrackers.length) {
                    if (!identifiedTrackers[j]) {
                        trackerChoices[k++] = Integer.toString(j + 1);
                    }
                    ++j;
                }
                if (!c.isConnected() || c.isIdentified()) {
                    this.m_trackers.remove(i2);
                    --i2;
                } else {
                    byte trackerNumber = -1;
                    int j2 = 0;
                    while (j2 < SettingsManager.defaultTrackerIPAddress.length) {
                        InetAddress trackerIP = SystemManager.settings.getTrackerIPAddress(j2 + 1);
                        if (trackerIP.equals(c.getIPAddress())) {
                            trackerNumber = (byte)(j2 + 1);
                            break;
                        }
                        ++j2;
                    }
                    if (trackerNumber != -1) {
                        boolean bl = trackerIdentified = JOptionPane.showConfirmDialog(null, "Tracker \"" + c.getIPAddressString() + "\" identified as Tracker #" + trackerNumber + ".\nIs this correct?", "Tracker Identified", 0, 3) == 0;
                    }
                    if (!c.isConnected()) {
                        this.m_trackers.remove(i2);
                        --i2;
                    } else {
                        if (!trackerIdentified) {
                            Object input;
                            boolean validInput;
                            while (!(validInput = (input = JOptionPane.showInputDialog(null, "Please choose which tracker this is.", "Identify Tracker", 3, null, trackerChoices, trackerChoices[0])) != null)) {
                            }
                            try {
                                trackerNumber = Byte.parseByte(input.toString());
                                trackerIdentified = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!c.isConnected()) {
                            this.m_trackers.remove(i2);
                            --i2;
                        } else {
                            boolean trackerAlreadyIdentified = false;
                            if (trackerIdentified) {
                                int j3 = 0;
                                while (j3 < this.m_server.numberOfClients()) {
                                    if (this.m_server.getClient(j3).getTrackerNumber() == trackerNumber) {
                                        JOptionPane.showMessageDialog(null, "This tracker number has already been taken, please choose another!", "Tracker Number Taken", 2);
                                        trackerAlreadyIdentified = true;
                                    }
                                    ++j3;
                                }
                                if (!trackerAlreadyIdentified) {
                                    c.setTrackerNumber(trackerNumber);
                                    SystemManager.console.writeLine("Client #" + c.getClientNumber() + " identified as Tracker #" + c.getTrackerNumber() + ".");
                                }
                            } else {
                                JOptionPane.showMessageDialog(null, "Unable to identify tracker.", "Tracker Unidentified", 0);
                                c.disconnect();
                            }
                            if (trackerAlreadyIdentified) break;
                            this.m_trackers.remove(i2);
                            --i2;
                        }
                    }
                }
                ++i2;
            }
            try {
                TrackerIdentifier.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

