/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.io.IOException;
import java.io.PrintWriter;

public class Variable {
    private int m_category = -1;
    private String m_id;
    private String m_value;
    public static final char SEPARATOR_CHAR = ':';
    public static final int NO_CATEGORY = -1;

    public Variable() {
        this("", "", -1);
    }

    public Variable(String id, String value) {
        this(id, value, -1);
    }

    public Variable(String id, String value, int category) {
        this.m_id = id == null ? "" : id.trim();
        this.m_value = value == null ? "" : value.trim();
        this.m_category = category < -1 ? -1 : category;
    }

    public int getCategory() {
        return this.m_category;
    }

    public String getID() {
        return this.m_id;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setCategory(int category) {
        this.m_category = category < -1 ? -1 : category;
    }

    public void setID(String id) {
        this.m_id = id == null ? "" : id.trim();
    }

    public void setValue(String value) {
        this.m_value = value == null ? "" : value.trim();
    }

    public void removeCategory() {
        this.m_category = -1;
    }

    public static Variable parseFrom(String data) {
        if (data == null) {
            return null;
        }
        String temp = data.trim();
        if (temp.length() < 1) {
            return null;
        }
        int separatorIndex = temp.indexOf(58);
        if (separatorIndex == -1) {
            return null;
        }
        String id = temp.substring(0, separatorIndex);
        String value = temp.substring(separatorIndex + 1, temp.length());
        return new Variable(id, value, -1);
    }

    public void writeTo(PrintWriter out) throws IOException {
        if (out == null) {
            return;
        }
        out.println(String.valueOf(this.m_id) + ':' + " " + this.m_value);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Variable)) {
            return false;
        }
        Variable v = (Variable)o;
        return this.m_id.equalsIgnoreCase(v.m_id);
    }

    public String toString() {
        return String.valueOf(this.m_id) + ':' + " " + this.m_value;
    }
}

