/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.util.Vector;
import server.SystemManager;
import shared.SystemConsoleEntry;
import shared.Updatable;

public class SystemConsole {
    private Vector<SystemConsoleEntry> m_consoleEntries = new Vector();
    private Updatable m_target;

    public void setTarget(Updatable target) {
        this.m_target = target;
    }

    public int size() {
        return this.m_consoleEntries.size();
    }

    public SystemConsoleEntry getConsoleEntry(int index) {
        if (index < 0 || index >= this.m_consoleEntries.size()) {
            return null;
        }
        return this.m_consoleEntries.elementAt(index);
    }

    public void writeLine(String text) {
        this.m_consoleEntries.add(new SystemConsoleEntry(text));
        while (this.m_consoleEntries.size() > SystemManager.settings.getMaxConsoleHistory()) {
            this.m_consoleEntries.remove(0);
        }
        if (this.m_target != null) {
            this.m_target.update();
        }
    }

    public void clear() {
        this.m_consoleEntries.clear();
        if (this.m_target != null) {
            this.m_target.update();
        }
    }

    public String toString() {
        String data = "";
        int i = 0;
        while (i < this.m_consoleEntries.size()) {
            data = String.valueOf(data) + this.m_consoleEntries.elementAt(i).getText() + "\n";
            ++i;
        }
        return data;
    }
}

