/*
 * Decompiled with CFR 0.152.
 */
package signal;

import block.BlockState;
import shared.ByteStream;
import signal.Signal;

public class BlockStateChangeSignal
extends Signal {
    private byte m_blockID;
    private byte m_robotID;
    private byte m_blockState;
    public static final int LENGTH = 11;

    private BlockStateChangeSignal() {
        super(3);
    }

    public BlockStateChangeSignal(byte blockID, byte robotID, byte blockState) {
        super(3);
        this.m_blockID = blockID;
        this.m_robotID = robotID;
        this.m_blockState = blockState;
    }

    public byte getBlockID() {
        return this.m_blockID;
    }

    public byte getRobotID() {
        return this.m_robotID;
    }

    public byte getBlockState() {
        return this.m_blockState;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_blockID);
        checksum += ByteStream.getChecksum(this.m_robotID);
        return checksum += ByteStream.getChecksum(this.m_blockState);
    }

    public static BlockStateChangeSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        BlockStateChangeSignal s2 = new BlockStateChangeSignal();
        s2.m_blockID = byteStream.nextByte();
        s2.m_robotID = byteStream.nextByte();
        s2.m_blockState = byteStream.nextByte();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addByte(this.m_blockID);
        byteStream.addByte(this.m_robotID);
        byteStream.addByte(this.m_blockState);
        byteStream.addLong(this.checksum());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Block ID: " + this.m_blockID + " Robot ID: " + this.m_robotID + " Block State " + BlockState.toString(this.m_blockState);
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return BlockStateChangeSignal.readFrom(byteStream);
    }
}

