/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class ReceiveTrackerNumberSignal
extends Signal {
    private byte m_trackerNumber;
    public static final int LENGTH = 9;

    private ReceiveTrackerNumberSignal() {
        super(15);
    }

    public ReceiveTrackerNumberSignal(byte trackerNumber) {
        super(15);
        this.m_trackerNumber = trackerNumber;
    }

    public byte getTrackerNumber() {
        return this.m_trackerNumber;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        return checksum += ByteStream.getChecksum(this.m_trackerNumber);
    }

    public static ReceiveTrackerNumberSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        ReceiveTrackerNumberSignal s2 = new ReceiveTrackerNumberSignal();
        s2.m_trackerNumber = byteStream.nextByte();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addByte(this.m_trackerNumber);
        byteStream.addLong(this.checksum());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Tracker ID: " + this.m_trackerNumber;
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return ReceiveTrackerNumberSignal.readFrom(byteStream);
    }
}

