/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class RequestTrackerImageSignal
extends Signal {
    private byte m_sourceTrackerNumber;
    public static final int LENGTH = 9;

    private RequestTrackerImageSignal() {
        super(12);
    }

    public RequestTrackerImageSignal(byte sourceTrackerNumber) {
        super(12);
        this.m_sourceTrackerNumber = sourceTrackerNumber;
    }

    public byte getSourceTrackerNumber() {
        return this.m_sourceTrackerNumber;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        return checksum += ByteStream.getChecksum(this.m_sourceTrackerNumber);
    }

    public static RequestTrackerImageSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        RequestTrackerImageSignal s2 = new RequestTrackerImageSignal();
        s2.m_sourceTrackerNumber = byteStream.nextByte();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addByte(this.m_sourceTrackerNumber);
        byteStream.addLong(this.checksum());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Source Tracker ID: " + this.m_sourceTrackerNumber;
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return RequestTrackerImageSignal.readFrom(byteStream);
    }
}

