/*
 * Decompiled with CFR 0.152.
 */
package signal;

import robot.RobotState;
import shared.ByteStream;
import signal.Signal;

public class RobotStateChangeSignal
extends Signal {
    private byte m_robotID;
    private byte m_robotState;
    public static final int LENGTH = 10;

    private RobotStateChangeSignal() {
        super(4);
    }

    public RobotStateChangeSignal(byte robotID, byte robotState) {
        super(4);
        this.m_robotID = robotID;
        this.m_robotState = robotState;
    }

    public byte getRobotID() {
        return this.m_robotID;
    }

    public byte getRobotState() {
        return this.m_robotState;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_robotID);
        return checksum += ByteStream.getChecksum(this.m_robotState);
    }

    public static RobotStateChangeSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        RobotStateChangeSignal s2 = new RobotStateChangeSignal();
        s2.m_robotID = byteStream.nextByte();
        s2.m_robotState = byteStream.nextByte();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addByte(this.m_robotID);
        byteStream.addByte(this.m_robotState);
        byteStream.addLong(this.checksum());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Robot ID: " + this.m_robotID + " Robot State " + RobotState.toString(this.m_robotState);
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return RobotStateChangeSignal.readFrom(byteStream);
    }
}

