/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import shared.Position;
import shared.RobotPosition;
import signal.Signal;

public class UpdateEstimatedRobotPositionSignal
extends Signal {
    private byte m_robotID;
    private int m_x;
    private int m_y;
    private int m_angle;
    public static final int LENGTH = 21;

    private UpdateEstimatedRobotPositionSignal() {
        super(11);
    }

    public UpdateEstimatedRobotPositionSignal(byte robotID, RobotPosition robotPosition) {
        this(robotID, robotPosition == null ? -1 : robotPosition.getX(), robotPosition == null ? -1 : robotPosition.getY(), robotPosition == null ? -1 : robotPosition.getAngleDegrees());
    }

    public UpdateEstimatedRobotPositionSignal(byte robotID, int x, int y, int angle) {
        super(11);
        this.m_robotID = robotID;
        this.m_x = x;
        this.m_y = y;
        this.m_angle = angle;
    }

    public byte getRobotID() {
        return this.m_robotID;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public int getAngle() {
        return this.m_angle;
    }

    public Position getPosition() {
        return new Position(this.m_x, this.m_y);
    }

    public RobotPosition getRobotPosition() {
        return new RobotPosition(this.m_x, this.m_y, this.m_angle);
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_robotID);
        checksum += ByteStream.getChecksum(this.m_x);
        checksum += ByteStream.getChecksum(this.m_y);
        return checksum += ByteStream.getChecksum(this.m_angle);
    }

    public static UpdateEstimatedRobotPositionSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        UpdateEstimatedRobotPositionSignal s2 = new UpdateEstimatedRobotPositionSignal();
        s2.m_robotID = byteStream.nextByte();
        s2.m_x = byteStream.nextInteger();
        s2.m_y = byteStream.nextInteger();
        s2.m_angle = byteStream.nextInteger();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addByte(this.m_robotID);
        byteStream.addInteger(this.m_x);
        byteStream.addInteger(this.m_y);
        byteStream.addInteger(this.m_angle);
        byteStream.addLong(this.checksum());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Robot ID: " + this.m_robotID + " Position: (" + this.m_x + ", " + this.m_y + ") Angle: " + this.m_angle;
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return UpdateEstimatedRobotPositionSignal.readFrom(byteStream);
    }
}

