/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp;

import com.rbcapp.bluetooth.RBCBlue;
import com.rbcapp.camera.CameraImage;
import com.rbcapp.planner.RBCPlannerHandler;
import com.rbcapp.server.RBCServer;
import com.rbcapp.settings.RBCSettings;
import com.rbcapp.window.RBCWindow;
import java.awt.Color;
import java.awt.Image;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Time;
import java.util.ArrayList;

public class RBCApp {
    private RBCWindow window;
    private RBCBlue bluetooth;
    private RBCServer server;
    private boolean firstTimeWriting = true;
    private boolean useEasyBlue;
    private RBCSettings settings = RBCSettings.loadSettings("settings.ini");
    private RBCPlannerHandler handler;
    private File lastPlannerFile = null;
    private CameraImage image = new CameraImage();

    public RBCApp(boolean easyBlue) {
        this.window = new RBCWindow(this, this.settings);
        this.window.setVisible(true);
        this.bluetooth = new RBCBlue(this, this.settings, easyBlue);
        this.useEasyBlue = easyBlue;
        if (this.useEasyBlue) {
            this.window.enableRobotConnection();
        }
        if (!this.useEasyBlue) {
            this.bluetooth.start();
        }
        this.server = new RBCServer(this);
        this.server.start();
    }

    public void closed() {
        this.downBluetooth();
        this.downServer();
        System.exit(0);
    }

    public RBCSettings getSettings() {
        return this.settings;
    }

    public void receivedStationData(int id, byte[] data) {
        if (this.handler != null && this.handler.isAlive()) {
            this.handler.stationDataReceived(id, data);
        }
    }

    public void receivedTrackerData(byte[] data) {
        if (this.handler != null && this.handler.isAlive()) {
            this.handler.trackerDataReceived(data);
        }
    }

    public void receivedPlannerData(byte[] data, int flag) {
        String timeStamped = "";
        if (this.settings.timeStamped) {
            timeStamped = "[" + new Time(System.currentTimeMillis()) + "] ";
        }
        String output = "";
        int i = 0;
        while (i < data.length) {
            output = String.valueOf(output) + new Integer(data[i] & 0xFF).toString() + ",";
            ++i;
        }
        switch (flag) {
            case 1: {
                this.window.appendLogOutput(new String(output));
                break;
            }
            case 2: {
                String tempString = new String(output);
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter(this.settings.fileOutputName, !this.firstTimeWriting));
                    out.write("\r\n" + timeStamped + tempString);
                    out.close();
                    this.firstTimeWriting = false;
                }
                catch (IOException e) {
                    this.log("ERROR: Could not write to file " + this.settings.fileOutputName);
                }
                break;
            }
            case 3: {
                this.window.appendLogOutput(output);
                String tString = new String(output);
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter(this.settings.fileOutputName, !this.firstTimeWriting));
                    out.write("\r\n" + timeStamped + tString);
                    out.close();
                    this.firstTimeWriting = false;
                    break;
                }
                catch (IOException e) {
                    this.log("ERROR: Could not write to file " + this.settings.fileOutputName);
                }
            }
        }
        if (this.handler != null && this.handler.isAlive()) {
            this.handler.dataReceived(data);
        }
    }

    public void receivedRobotData(byte[] data) {
        this.bluetooth.sendData(data);
    }

    public void downServer() {
        this.server.interrupt();
    }

    public boolean loadPlanner(File plannerFile) {
        try {
            this.handler = new RBCPlannerHandler(this, plannerFile.getParentFile().toURL(), plannerFile.getName().split("\\.")[0], this.settings);
            this.lastPlannerFile = plannerFile;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void unloadPlanner() {
        this.handler.interrupt();
        this.handler = null;
    }

    public void connectBluetooth() {
        this.bluetooth.start();
    }

    public void setURL(String string) {
        this.bluetooth.setURL(string);
    }

    public void resetBluetooth() {
        this.bluetooth.interrupt();
        this.bluetooth = new RBCBlue(this, this.settings, this.useEasyBlue);
    }

    public void downBluetooth() {
        this.bluetooth.interrupt();
    }

    public void sendData(byte[] data) {
        this.bluetooth.sendData(data);
    }

    public void sendDebugData(byte[] data) {
        this.bluetooth.sendDebugData(data);
    }

    public void robotConnected() {
        this.window.robotConnected();
    }

    public void robotDisconnected() {
        this.window.robotDisconnected();
    }

    public void enableInput() {
        this.window.enableInput();
    }

    public void disableInput() {
        this.window.disableInput();
    }

    public void clearDebug() {
        this.window.clearDebug();
    }

    public void clearImage() {
        this.image.fullReset();
        this.window.setOutputImage(this.image.getImage());
    }

    public void enableScan() {
        this.window.enableScan();
    }

    public boolean startButtonHit() {
        this.firstTimeWriting = true;
        if (!this.useEasyBlue) {
            byte[] data = new byte[]{11};
            this.bluetooth.sendSpecificData(data);
        }
        if (this.handler != null) {
            this.handler.start();
            return true;
        }
        return false;
    }

    public boolean stopButtonHit() {
        if (this.handler != null) {
            this.handler.interrupt();
            try {
                this.handler = new RBCPlannerHandler(this, this.lastPlannerFile.getParentFile().toURL(), this.lastPlannerFile.getName().split("\\.")[0], this.settings);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void enableStartButton() {
        this.window.enableStartButton();
    }

    public void appendDebug(byte[] output) {
        String tempString = new String(output);
        this.window.appendDebugOutput(tempString);
    }

    public void appendLineDebug(byte[] output) {
        String tempString = new String(output);
        this.window.appendLineDebugOutput(tempString);
    }

    public void outputImage(ArrayList<Integer> output) {
        this.image.setImage(output);
        this.window.setOutputImage(this.image.getImage());
    }

    public void outputImageTrace(ArrayList<Integer> data) {
        this.image.addBlob(data);
        Image img = this.image.getImage();
        if (this.image != null) {
            this.window.setOutputImage(img);
        }
    }

    public void imageColor(int r, int g, int b) {
        this.image.setColor(r, g, b);
    }

    public void log(String str) {
        System.out.println(str);
    }

    public void changeStatusBar(String string, Color color) {
        this.window.changeStatusBar(string, color);
    }

    public static void main(String[] args) {
        boolean scanner = false;
        boolean easyBlue = true;
        int i = 0;
        while (i < args.length) {
            if (args[i].compareTo("-scan") == 0) {
                scanner = true;
            } else if (args[i].compareTo("-eb500") == 0) {
                easyBlue = false;
            }
            ++i;
        }
        RBCApp app = new RBCApp(easyBlue);
        if (scanner) {
            app.enableScan();
        }
    }
}

