/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp.bluetooth;

import com.rbcapp.RBCApp;
import com.rbcapp.bluetooth.BluetoothComm;
import com.rbcapp.settings.RBCSettings;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.LinkedList;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class BluetoothServerEasyBlue
extends BluetoothComm {
    private String blueURL;

    public BluetoothServerEasyBlue(RBCApp app2, RBCSettings setts) {
        super(setts);
        this.app = app2;
        this.queue = new LinkedList();
    }

    public void setURL(String url) {
        this.blueURL = url;
    }

    @Override
    public void startServer() throws Exception {
        try {
            String connectionString = this.blueURL;
            this.app.changeStatusBar("Connecting to robot " + this.app.getSettings().robotId + "...", Color.YELLOW.darker().darker());
            StreamConnection connection = (StreamConnection)Connector.open((String)connectionString);
            InputStream inStream = connection.openInputStream();
            BufferedReader bReader = new BufferedReader(new InputStreamReader(inStream));
            OutputStream outStream = connection.openOutputStream();
            DataOutputStream pWriter = new DataOutputStream(outStream);
            pWriter.write(10);
            pWriter.flush();
            int ack = -1;
            while (ack != 8) {
                if (bReader.ready()) {
                    ack = bReader.read();
                }
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            pWriter.write(11);
            pWriter.flush();
            this.startListening(bReader, pWriter);
            try {
                connection.close();
            }
            catch (NullPointerException e) {
                System.out.println("[ERROR] Unable to start Bluetooth server.");
            }
        }
        catch (InterruptedIOException connectionString) {
        }
        catch (IOException e) {
            this.app.changeStatusBar("Unable to connect to robot " + this.app.getSettings().robotId, Color.RED);
            this.app.robotDisconnected();
            return;
        }
    }
}

