/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp.camera;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class CameraImage {
    private static int width = 160;
    private static int height = 144;
    private volatile BufferedImage img;
    private volatile ArrayList<Integer[]> blobs;
    private Color blobColor = new Color(0, 0, 0);

    public CameraImage() {
        this.blobs = new ArrayList();
        this.resetImageToBlack();
    }

    public void resetImage() {
        this.img = new BufferedImage(width, height, 5);
    }

    public void fullReset() {
        this.img = new BufferedImage(width, height, 5);
        this.blobs = new ArrayList();
    }

    public void addBlob(ArrayList<Integer> data) {
        int r = 0;
        int b = 0;
        int g = 0;
        Integer[] blob = null;
        Color blobColor = new Color(r, g, b);
        int i = 0;
        while (i < this.blobs.size()) {
            if (blobColor.getRGB() == this.blobs.get(i)[0].intValue()) {
                blob = this.blobs.get(i);
                break;
            }
            ++i;
        }
        if (blob == null) {
            blob = new Integer[5];
            this.blobs.add(blob);
            blob[0] = blobColor.getRGB();
        }
        if (data.get(0) == 0 && data.get(1) == 0 && data.get(2) == 0 && data.get(3) == 0) {
            this.blobs.remove(blob);
        }
        blob[1] = data.get(0);
        blob[2] = data.get(1);
        blob[3] = data.get(2);
        blob[4] = data.get(3);
    }

    public void setColor(int r, int g, int b) {
        this.blobColor = new Color(r, g, b);
    }

    public void resetImageToBlack() {
        this.img = new BufferedImage(width, height, 5);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                this.img.setRGB(x, y, Color.BLACK.getRGB());
                ++y;
            }
            ++x;
        }
    }

    public Image getImage() {
        this.resetImage();
        BufferedImage image = this.img;
        int i = 0;
        while (i < this.blobs.size()) {
            int y2;
            int x2;
            int y1;
            Integer[] blob = this.blobs.get(i);
            int x1 = blob[1];
            if (x1 < 0) {
                x1 = 0;
            }
            if ((y1 = blob[2].intValue()) < 0) {
                y1 = 0;
            }
            if ((x2 = blob[3] * 2) > width - 1) {
                x2 = width - 1;
            }
            if ((y2 = blob[4].intValue()) > height - 1) {
                y2 = height - 1;
            }
            int x = x1;
            while (x <= x2) {
                int y = y1;
                while (y <= y2) {
                    image.setRGB(x, y, this.blobColor.getRGB());
                    ++y;
                }
                ++x;
            }
            ++i;
        }
        if (this.blobs.size() == 0) {
            Graphics g = image.getGraphics();
            g.setColor(Color.WHITE);
            FontMetrics m = g.getFontMetrics();
            String message = "[Tracking colour not found]";
            int width = m.stringWidth(message) / 2;
            g.drawString(message, image.getWidth() / 2 - width, image.getHeight() / 2);
            return image;
        }
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
        tx.translate(-image.getWidth(null), -image.getHeight());
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        image = op.filter(image, null);
        return image;
    }

    public static BufferedImage getColorImaged(Color color) {
        BufferedImage image = new BufferedImage(width, height, 5);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int pixel = color.getRGB();
                image.setRGB(x, y, pixel);
                ++y;
            }
            ++x;
        }
        return image;
    }

    public void setImage(ArrayList<Integer> pixels) {
        this.img = new BufferedImage(width, height, 5);
        if (pixels.get(0) != 1) {
            System.out.println("[Error] Unable to create image from camera dump, dump invalid.");
            this.img = CameraImage.getColorImaged(Color.black);
        }
        int counter = 1;
        int column = 0;
        int row = 0;
        while (counter + 3 < pixels.size()) {
            if (pixels.get(counter) == 2) {
                column += 2;
                row = 0;
                ++counter;
                continue;
            }
            if (pixels.get(counter) == 3) break;
            int pixel = 0;
            pixel += pixels.get(counter).intValue();
            pixel += pixels.get(counter + 1) << 8;
            Color color = new Color(pixel += pixels.get(counter + 2) << 16);
            this.img.setRGB(column, row, color.getRGB());
            this.img.setRGB(column + 1, row, color.getRGB());
            ++row;
            counter += 3;
        }
    }
}

