/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp.planner;

import com.rbcapp.RBCApp;
import com.rbcapp.planner.Planner;
import com.rbcapp.planner.Pose;
import com.rbcapp.planner.RBCTracker;
import com.rbcapp.server.RBCServer;
import com.rbcapp.settings.RBCSettings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;

public class RBCPlannerHandler
extends Thread {
    private Pose prevPose;
    private Class<?> plannerClass;
    private Object planner;
    private RBCApp app;
    private volatile RBCSettings settings;
    private boolean shutdown = false;
    private URL location;
    private String name;
    private long lastModified;
    private volatile File currentTraceFile;
    private boolean writeToFile = false;
    volatile LinkedList<byte[]> dataReceivedQ;
    volatile LinkedList<byte[]> stationDataReceivedQ;
    private Method poseReceived;
    private Method dataReceived;
    private Method stationDataReceived;
    private Method trackerDataReceived;

    public RBCPlannerHandler(RBCApp app2, URL plannerLocation, String plannerName, RBCSettings setts) throws ClassNotFoundException {
        this.app = app2;
        this.location = plannerLocation;
        this.name = plannerName;
        this.settings = setts;
        this.dataReceivedQ = new LinkedList();
        this.stationDataReceivedQ = new LinkedList();
        File file = new File(String.valueOf(this.location.getPath()) + "\\" + this.name + ".class");
        this.lastModified = file.lastModified();
        this.prevPose = new Pose(-1, -1, -1);
        try {
            URL[] url = new URL[]{plannerLocation};
            URLClassLoader loader = new URLClassLoader(url);
            this.plannerClass = loader.loadClass(plannerName);
        }
        catch (Exception e) {
            this.app.log("[ERROR] Unable to load planner.");
            this.shutdown = true;
            throw new ClassNotFoundException();
        }
        this.grabMethods(true);
        if (this.shutdown) {
            this.app.unloadPlanner();
        }
    }

    private boolean grabMethods(boolean reportError) {
        try {
            this.poseReceived = this.plannerClass.getMethod("receivedPoseFromTracker", Pose.class);
        }
        catch (NoSuchMethodException e) {
            if (reportError) {
                System.out.println("[ERROR]: Planner must have a receivedPoseFromTracker method.");
                this.shutdown = true;
            }
            return false;
        }
        try {
            this.dataReceived = this.plannerClass.getMethod("receivedDataFromRobot", int[].class);
        }
        catch (NoSuchMethodException e) {
            if (reportError) {
                System.out.println("[ERROR]: Planner must have a receivedDataFromRobot method.");
                this.shutdown = true;
            }
            return false;
        }
        try {
            this.stationDataReceived = this.plannerClass.getMethod("receivedDataFromStation", Integer.TYPE, int[].class);
        }
        catch (NoSuchMethodException e) {
            if (reportError) {
                System.out.println("[ERROR]: Planner must have a receivedDataFromStation method.");
                this.shutdown = true;
            }
            return false;
        }
        try {
            this.trackerDataReceived = this.plannerClass.getMethod("receivedDataFromTracker", int[].class);
        }
        catch (NoSuchMethodException e) {
            if (reportError) {
                System.out.println("[ERROR]: Planner must have a receivedDataFromTacker method.");
                this.shutdown = true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        File file = new File(String.valueOf(this.location.getPath()) + "\\" + this.name + ".class");
        int count = 1;
        this.currentTraceFile = new File("traces\\trace" + count + ".trc");
        while (this.currentTraceFile.exists()) {
            this.currentTraceFile = new File("traces\\trace" + ++count + ".trc");
        }
        Class<?> oldClass = this.plannerClass;
        Method oldPoseReceived = this.poseReceived;
        Method oldDataReceived = this.dataReceived;
        Method oldStationDataReceived = this.stationDataReceived;
        if (file.lastModified() != this.lastModified) {
            try {
                URL[] url = new URL[]{this.location};
                URLClassLoader loader = new URLClassLoader(url);
                this.plannerClass = loader.loadClass(this.name);
            }
            catch (ClassNotFoundException e) {
                this.plannerClass = oldClass;
                this.poseReceived = oldPoseReceived;
                this.dataReceived = oldDataReceived;
                this.stationDataReceived = oldStationDataReceived;
            }
            if (!this.grabMethods(false)) {
                oldClass = this.plannerClass;
                this.poseReceived = oldPoseReceived;
                this.dataReceived = oldDataReceived;
                this.stationDataReceived = oldStationDataReceived;
                System.out.println("[ERROR] Unable to load planner, required methods are missing.");
                return;
            }
        }
        try {
            Constructor<?>[] cons = this.plannerClass.getConstructors();
            this.planner = cons[0].newInstance(this);
        }
        catch (InstantiationException e) {
            this.app.log("[ERROR] Cannot start planner.");
            Thread.currentThread().interrupt();
            return;
        }
        catch (IllegalAccessException e) {
            this.app.log("[ERROR] Cannot start planner.");
            Thread.currentThread().interrupt();
            return;
        }
        catch (Exception e) {
            this.app.log("[ERROR] Cannot start planner.");
            Thread.currentThread().interrupt();
            return;
        }
        if (this.shutdown) {
            return;
        }
        long timedMillis = 0L;
        if (this.settings.outputTraceFile) {
            try {
                FileWriter write = new FileWriter(this.currentTraceFile);
                write.write("x,y,angle");
                if (((Planner)this.planner).userTitle.compareTo("") != 0) {
                    write.write("," + ((Planner)this.planner).userTitle);
                }
                write.close();
                this.writeToFile = true;
            }
            catch (Exception e) {
                System.out.println("[ERROR] Unable to write to trace file.");
                e.printStackTrace();
            }
        }
        this.prevPose = new Pose(-1, -1, -1);
        while (true) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            if ((float)(System.currentTimeMillis() - timedMillis) < 1000.0f / ((Planner)this.planner).getFrameRate()) {
                this.receivedMethods();
                continue;
            }
            Pose robotPose = new Pose(-1, -1, -1);
            try {
                robotPose = RBCTracker.getPose(this.settings.robotId);
            }
            catch (IOException e) {
                this.app.log("[ERROR]: Unable to connect to the RobotTracker Server!");
                continue;
            }
            this.recordTrace(robotPose, this.prevPose);
            this.poseReceived(robotPose);
            timedMillis = System.currentTimeMillis();
            this.receivedMethods();
            this.prevPose = robotPose;
        }
    }

    private void recordTrace(Pose pose, Pose prevPose) {
        if (this.writeToFile && this.poseDifferent(prevPose, pose)) {
            try {
                FileWriter write = new FileWriter(this.currentTraceFile, true);
                write.write("\r\n" + pose.x + "," + pose.y + "," + pose.angle);
                write.close();
            }
            catch (Exception e) {
                System.out.println("[ERROR] Unable to write to trace file.");
            }
        }
    }

    public void postTraceData(String data) {
        if (this.writeToFile) {
            try {
                FileWriter write = new FileWriter(this.currentTraceFile, true);
                write.write("," + data);
                write.close();
            }
            catch (Exception e) {
                System.out.println("[ERROR] Unable to write to trace file.");
            }
        }
    }

    private boolean poseDifferent(Pose p1, Pose p2) {
        return p1.x != p2.x || p1.y != p2.y || p1.angle != p2.angle;
    }

    private void receivedMethods() {
    }

    public void poseReceived(Pose robotPose) {
        try {
            this.poseReceived.invoke(this.planner, robotPose);
        }
        catch (Exception e) {
            System.out.println("[ERROR] Unable to call poseReceived in planner.");
        }
    }

    public void dataReceived(byte[] data2) {
        int[] data = new int[data2.length];
        int i = 0;
        while (i < data2.length) {
            data[i] = data2[i] & 0xFF;
            ++i;
        }
        try {
            this.dataReceived.invoke(this.planner, new Object[]{data});
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("[ERROR] Unable to call dataReceived in planner.");
        }
    }

    public void stationDataReceived(int id, byte[] data2) {
        int[] data = new int[data2.length];
        int i = 0;
        while (i < data2.length) {
            data[i] = data2[i] & 0xFF;
            ++i;
        }
        try {
            this.stationDataReceived.invoke(this.planner, id, data);
        }
        catch (Exception e) {
            System.out.println("[ERROR] Unable to call stationDataReceived in planner.");
        }
    }

    public void trackerDataReceived(byte[] data2) {
        int[] data = new int[data2.length];
        int i = 0;
        while (i < data2.length) {
            data[i] = data2[i] & 0xFF;
            ++i;
        }
        try {
            this.trackerDataReceived.invoke(this.planner, new Object[]{data});
        }
        catch (Exception e) {
            System.out.println("[ERROR] Unable to call trackerDataReceived in planner.");
        }
    }

    public void sendData(byte[] data) {
        this.app.sendData(data);
    }

    public void sendStationData(int station, byte[] data) {
        byte[] data2 = new byte[data.length + 3];
        data2[0] = 1;
        data2[1] = (byte)this.settings.currentStation;
        data2[2] = (byte)data.length;
        int i = 0;
        while (i < data.length) {
            data2[i + 3] = data[i];
            ++i;
        }
        RBCServer.sendServerData(station, data2, this.settings);
    }

    public void sendEstimatedPositionToTracker(int x, int y, int angle) {
        byte[] data = new byte[]{10, 2, (byte)(x / 256), (byte)(x % 256), (byte)(y / 256), (byte)(y % 256), (byte)(angle / 256), (byte)(angle % 256)};
        int i = 0;
        while (i < data.length) {
            System.out.print(" " + (data[i] & 0xFF));
            ++i;
        }
        System.out.println("");
        RBCTracker.sendData(data);
    }

    public void sendTrackerData(byte[] data2) {
        byte[] data = new byte[data2.length + 9];
        data[0] = 10;
        data[1] = 3;
        data[2] = (byte)(this.prevPose.x / 256);
        data[3] = (byte)(this.prevPose.x % 256);
        data[4] = (byte)(this.prevPose.y / 256);
        data[5] = (byte)(this.prevPose.y % 256);
        data[6] = (byte)(this.prevPose.angle / 256);
        data[7] = (byte)(this.prevPose.angle % 256);
        data[8] = (byte)data2.length;
        int i = 0;
        while (i < data2.length) {
            data[i + 9] = data2[i];
            ++i;
        }
        RBCTracker.sendData(data);
    }

    public Pose[] getDesiredPath() {
        byte[] path;
        try {
            path = RBCTracker.getDesiredPath();
        }
        catch (Exception e) {
            System.out.println("[ERROR] Unable to retrieve desired path from the Robot Tracker.");
            return null;
        }
        System.out.print("Received ");
        int i = 0;
        while (i < path.length) {
            System.out.print(" " + (path[i] & 0xFF));
            ++i;
        }
        System.out.println("");
        Pose[] desiredPath = this.convertDataToPoses(path);
        return desiredPath;
    }

    private Pose[] convertDataToPoses(byte[] data) {
        int size = data[2];
        if (size % 4 != 0) {
            return null;
        }
        Pose[] poses = new Pose[size / 4];
        int i = 0;
        while (i < size) {
            Pose pose = new Pose(0, 0, 0);
            int x = (data[i + 3] & 0xFF) * 256 + (data[i + 4] & 0xFF);
            int y = (data[i + 5] & 0xFF) * 256 + (data[i + 6] & 0xFF);
            int angle = -1;
            pose.x = x;
            pose.y = y;
            pose.angle = angle;
            poses[i / 4] = pose;
            i += 4;
        }
        return poses;
    }
}

