/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp.server;

import com.rbcapp.RBCApp;
import com.rbcapp.settings.RBCSettings;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class RBCServer
extends Thread {
    private static final int portNumber = 7001;
    private static final int bufferSize = 256;
    private RBCApp app;

    public RBCServer(RBCApp ap) {
        this.app = ap;
    }

    @Override
    public void run() {
        DatagramSocket socket;
        try {
            socket = new DatagramSocket(7001);
        }
        catch (SocketException e) {
            System.out.println(e.getStackTrace());
            this.app.log("[ERROR] Unable to open RBC socket server.");
            Thread.currentThread().interrupt();
            return;
        }
        while (true) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            byte[] buffer = new byte[256];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            try {
                socket.setSoTimeout(1000);
                socket.receive(packet);
            }
            catch (SocketTimeoutException e) {
                continue;
            }
            catch (Exception e) {
                continue;
            }
            int command = buffer[0] & 0xFF;
            int stationId = buffer[1] & 0xFF;
            int size = buffer[2] & 0xFF;
            byte[] data = new byte[size];
            int i = 0;
            while (i < size) {
                data[i] = buffer[i + 3];
                ++i;
            }
            if (command == 1) {
                this.app.receivedStationData(stationId, data);
                continue;
            }
            if (command == 2) {
                this.app.receivedRobotData(data);
                continue;
            }
            if (command != 10) continue;
            this.app.receivedTrackerData(data);
        }
        socket.close();
    }

    public static void sendServerData(int station, byte[] data, RBCSettings settings) {
        InetAddress address;
        String stationAddress;
        if (station == 1) {
            stationAddress = settings.station1Address;
        } else if (station == 2) {
            stationAddress = settings.station2Address;
        } else if (station == 3) {
            stationAddress = settings.station3Address;
        } else {
            System.out.println("[ERROR] Cannot send to an invalid station, " + station);
            return;
        }
        try {
            address = InetAddress.getByName(stationAddress);
        }
        catch (Exception e) {
            System.out.println("[ERROR] Unable to send message to station " + station + " at address " + stationAddress);
            return;
        }
        DatagramSocket socket = null;
        DatagramPacket sendPacket = null;
        try {
            socket = new DatagramSocket();
            sendPacket = new DatagramPacket(data, data.length, address, 7001);
            socket.send(sendPacket);
        }
        catch (Exception e) {
            System.out.println("[ERROR] Unable to send message.");
        }
    }

    public static void sendRobotData(int station, byte[] data, RBCSettings settings) {
        InetAddress address;
        String stationAddress;
        if (station == 1) {
            stationAddress = settings.station1Address;
        } else if (station == 2) {
            stationAddress = settings.station2Address;
        } else if (station == 3) {
            stationAddress = settings.station3Address;
        } else {
            System.out.println("[ERROR]: Cannot send to an invalid station, " + station);
            return;
        }
        try {
            address = InetAddress.getByName(stationAddress);
        }
        catch (Exception e) {
            System.out.println("[ERROR]: Unable to send message to station " + station + " at address " + stationAddress);
            return;
        }
        DatagramSocket socket = null;
        DatagramPacket sendPacket = null;
        try {
            socket = new DatagramSocket();
            sendPacket = new DatagramPacket(data, data.length, address, 7001);
            socket.send(sendPacket);
        }
        catch (Exception e) {
            System.out.println("[ERROR]: Unable to send message.");
        }
    }
}

