/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp.settings;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public class RBCSettings {
    public int robotId = -1;
    public String fileOutputName = "debugOutput.txt";
    public String station1Address = "134.117.28.108";
    public String station2Address = "134.117.28.109";
    public String station3Address = "134.117.28.110";
    public int currentStation = 1;
    public int comPort = 1;
    public boolean timeStamped = true;
    public boolean viewCamera = true;
    public boolean viewDebug = true;
    public boolean viewDebugInput = true;
    public TreeMap<Integer, String> robotAddresses = new TreeMap();
    public boolean outputTraceFile = false;
    public boolean outputTraceTracker = false;
    public boolean viewLog = true;

    public void saveSettings(String fileName) {
        try {
            BufferedWriter b = new BufferedWriter(new FileWriter(fileName));
            b.write("robotID=" + this.robotId);
            b.newLine();
            b.write("fileOutputName=" + this.fileOutputName.replaceAll("\\\\", "\\\\\\\\"));
            b.newLine();
            b.write("station1Address=" + this.station1Address);
            b.newLine();
            b.write("station2Address=" + this.station2Address);
            b.newLine();
            b.write("station3Address=" + this.station3Address);
            b.newLine();
            b.write("currentStation=" + this.currentStation);
            b.newLine();
            b.write("timeStamped=" + this.timeStamped);
            b.newLine();
            b.write("viewCamera=" + this.viewCamera);
            b.newLine();
            b.write("viewLog=" + this.viewLog);
            b.newLine();
            b.write("viewDebug=" + this.viewDebug);
            b.newLine();
            b.write("viewDebugInput=" + this.viewDebugInput);
            b.newLine();
            b.write("outputTraceTracker=" + this.outputTraceTracker);
            b.newLine();
            b.write("outputTraceFile=" + this.outputTraceFile);
            b.newLine();
            b.write("robotAddresses={");
            Object[] keys = this.robotAddresses.keySet().toArray();
            int i = 0;
            while (i < this.robotAddresses.keySet().size()) {
                b.write("[" + keys[i] + "," + this.robotAddresses.get(keys[i]) + "]");
                ++i;
            }
            b.write("}");
            b.newLine();
            b.write("comPort=" + this.comPort);
            b.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ERROR: Unable to save settings.", "Cannot Save Settings", 0);
        }
    }

    public static RBCSettings loadSettings(String fileName) {
        try {
            RBCSettings settings = new RBCSettings();
            Properties p = new Properties();
            p.load(new FileInputStream(fileName));
            settings.robotId = Integer.parseInt(p.getProperty("robotID"));
            settings.fileOutputName = p.getProperty("fileOutputName");
            settings.station1Address = p.getProperty("station1Address");
            settings.station2Address = p.getProperty("station2Address");
            settings.station3Address = p.getProperty("station3Address");
            settings.currentStation = Integer.parseInt(p.getProperty("currentStation"));
            settings.comPort = Integer.parseInt(p.getProperty("comPort"));
            settings.timeStamped = Boolean.parseBoolean(p.getProperty("timeStamped"));
            settings.viewCamera = Boolean.parseBoolean(p.getProperty("viewCamera"));
            settings.viewLog = Boolean.parseBoolean(p.getProperty("viewLog"));
            settings.viewDebug = Boolean.parseBoolean(p.getProperty("viewDebug"));
            settings.viewDebugInput = Boolean.parseBoolean(p.getProperty("viewDebugInput"));
            settings.outputTraceFile = Boolean.parseBoolean(p.getProperty("outputTraceFile"));
            settings.outputTraceTracker = Boolean.parseBoolean(p.getProperty("outputTraceTracker"));
            String tempAdd = p.getProperty("robotAddresses");
            if (tempAdd.startsWith("{") && tempAdd.substring(tempAdd.length() - 1).compareTo("}") == 0) {
                tempAdd = tempAdd.substring(1, tempAdd.length() - 1);
                tempAdd = tempAdd.replace("[", "");
                String[] pairs = tempAdd.split("]");
                int i = 0;
                while (i < pairs.length) {
                    String[] pair = pairs[i].split(",");
                    Integer key = new Integer(pair[0]);
                    String value = new String(pair[1]);
                    settings.robotAddresses.put(key, value);
                    ++i;
                }
            }
            return settings;
        }
        catch (Exception e) {
            System.out.println("[ERROR] Unable to load settings.");
            return new RBCSettings();
        }
    }
}

